require( "quest/m3_landing13/convout.lua" );
combine_speech_tables();

flo_anim_table =
{
	"anim/flo/stands", "anim/flo/standse", "anim/flo/talksegestures",
	"anim/flo/talks",
	"anim/flo/talkse",
	"anim/flo/walke",
	"anim/flo/walkn",
	"anim/flo/walkne",
	"anim/flo/walks",
	"anim/flo/walkse",
};

function gotopermitsoffice(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	flo:WalkTo("permits");
	wait_walkto();
	goto_scene(flo, "m3_permits");
end

permit_office_door_spec = 
{
	name = "PERMIT_OFFICE_DOOR";
	halo = "permit_office_door";
	cursor = "cursor_arrow_w";
	goto_fn = gotopermitsoffice;
};

function gotolobby(flo)
	flo:SetMode(MODE.CUTSCENE);
	game:ClearInvUsage();
	flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	sfx:PlaySFX("audio/sfx/big_elevator");
	scene.ELEVATOR:PlayAnim("Open");
	scene.ELEVATOR_BUTTON:PlayAnim("Down");
	flo:WalkTo("elevator");
	wait_walkto();
	goto_scene(flo, "m3_lobby");
end

function gotolanding50(flo)
	flo:SetMode(MODE.CUTSCENE);
	game:ClearInvUsage();
	flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	sfx:PlaySFX("audio/sfx/big_elevator");
	scene.ELEVATOR:PlayAnim("Open");
	scene.ELEVATOR_BUTTON:PlayAnim("Up");
	flo:WalkTo("elevator");
	wait_walkto();
	goto_scene(flo, "m3_landing50");
end

elevator_spec = 
{
	name = "ELEVATOR";
	halo = "elevator";
	gfx = { anim = "anim/m3_lobby/elevator_door" };
	
	command = function(actor)
		actor:SetDepthValue(2);
		actor:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		actor:PlayAnim("Closed");
	end;
	
	on_arrive = function(flo, button)				
		if ( game:Get( "visited_permits_office" ) == 1 ) then	
			if ( game:Get( "got_permit" ) == 1 ) then
				flo:StartProc(get_blue_keycard);
			else
				flo:StartProc(use_keycard);
			end
		else
			flo:StartProc(goto_permits_office);	
		end

	end;	
	on_use_inv = function(item, flo, elevator_blue)		
		if ( game:Get( "visited_permits_office" ) == 1 ) then		
			if ( item == "keycard" ) then
				if ( game:Get( "talked_to_barb_2" ) == 1 and game:Get( "blue_go_up" ) ~= 1 ) then
					game:Set( "blue_go_up", 1 );
					flo:StartProc(blue_go_up);	
				else
					flo:StartProc(gotolobby);
				end
			elseif ( item == "bluekey" ) then
				flo:StartProc(gotolanding50);
			end
		else
			flo:StartProc(goto_permits_office);
		end
	end;
}

elevator_button_spec = 
{
	name = "ELEVATOR_BUTTON";
	gfx = { anim = "anim/m3_lobby/elevator_button" };
	
	command = function(actor)
		actor:SetDepthValue(1);
		actor:AddFlag(AFLAG.AFLAG_SPECIAL_ANIM);
		actor:PlayAnim("Off");
	end;
}

function blue_go_up(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "quip_landing13_keycard_A");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function use_keycard(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "quip_landing13_elevator_B");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function goto_permits_office(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "quip_landing13_elevator_A");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function get_blue_keycard(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "quip_landing13_elevator_C");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function talk_to_barb(flo)
	flo:SetMode(MODE.CUTSCENE);
	
	flo:Face(DIR.W);
	delay(15);

	if ( game:Get( "talked_to_barb_1" ) ~= 1 ) then
		run_super_conversation(flo, "conv_landing13_barb");
		game:Set( "talked_to_barb_1", 1 );
		add_quest("keycard2");
		wait_subscene();
	else
		run_super_conversation(flo, "conv_landing13_need_more");
	end
		
	flo:Face(DIR.S);
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function use_inv_on_barb(flo, item)
	flo:StartProc(function(flo)
		flo:SetMode(MODE.CUTSCENE);
		flo:Face(DIR.W);
		delay(15);
		
		if item == "mugs" then
			BAG_INV:RemoveInventory("mugs");
			run_super_conversation(flo, "conv_give_mugs");
			addInventory( inv_desc_bluekey );
			game:Set( "talked_to_barb_2", 1 );
			complete_quest("keycard2");
			wait_subscene();
			flo:SetMode(MODE.FOLLOWCLICKS);
			return;
		elseif item == "mugcollection" then
			run_super_conversation(flo, "conv_landing13_need_more");
		else
			run_super_conversation(flo, "quip_landing13_barb_reject");
		end
		
		flo:Face(DIR.S);
		flo:SetMode(MODE.FOLLOWCLICKS);
	end);
end


barb_spec = 
{
	name = "BARB";
	halo = "quest/objects/barb";
	gfx = { anim = "anim/barb/kitchen" };
	
	command = function(actor)
		prepare_actor_text(actor, barb_text_spec);
		actor:ModifySaySpec{ mouth_in_actor = { x = 0, y = -90 } };
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:JumpToNamedPoint("barb");
		actor:FaceNow(DIR.E);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetWalkSpeed(barb_speed);
	end;
	
	on_arrive = function(flo, button)
		if ( game:Get( "got_permit" ) == 1 ) then	
			flo:StartProc(talk_to_barb);			
		end
	end;
	
	on_use_inv = function(item, flo, barb)
		use_inv_on_barb(flo, item);
	end;
};

function gotomaze(flo)
	flo:SetMode(MODE.CUTSCENE);
	
	if ( game:Get( "got_permit" ) == 1 ) then
		flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		flo:WalkTo("maze");
		wait_walkto();
		goto_scene(flo, "m3_maze2");
	else
		run_super_conversation(flo, "quip_landing13_maze_A");
		flo:SetMode(MODE.FOLLOWCLICKS);
	end
end

maze_spec = 
{
	name = "MAZE";
	halo = "maze";
	cursor = "cursor_arrow_e";
	goto_fn = gotomaze;
};

function flo_need_permit(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "quip_landing13_flo_A");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function flo_need_mugs(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "quip_landing13_flo_B");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function flo_need_50(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "quip_landing13_flo_C");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function flo_need_stamped(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "quip_landing13_flo_D");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

flo_spec =
{
	name = "FLO";
	halo = "quest/objects/flo";
	anim = flo_anim_table;
	cantuse = "obj_flo_cantuse";
	
	command = function(actor)
		prepare_actor_text(actor, flo_text_spec);
		actor:ModifySaySpec { mouth_in_actor = { x = 30, y = -145 } }
		actor:ModifySaySpec 
		{ 
			bubble_0 = bubble_b0_spec,
			bubble_1 = bubble_b1_spec,
			bubble = BUBBLE.BUBBLE_SHOW + BUBBLE.BUBBLE_FORCEVFLIP 
		};
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_NO_GROUND_CLICKS);
		actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);
		actor:AddFlag(AFLAG.AFLAG_SCALE_BY_Y);
		actor:SetWalkSpeed(flo_speed);
		
		local lastScene = game:GetLastScene();
		
		if lastScene == "m3_permits" then
			actor:JumpToNamedPoint("permits");
			actor:FaceNow(DIR.E);
		elseif lastScene == "m3_lobby" or lastScene == "m3_landing50" then
			actor:JumpToNamedPoint("elevator");
			sfx:PlaySFX("audio/sfx/big_elevator");
			scene.ELEVATOR:PlayAnim("Close");
			actor:FaceNow(DIR.S);
		else -- lastScene == m2_sunnyside
			actor:JumpToNamedPoint("maze");
			actor:FaceNow(DIR.W);
		end
		
		actor:WalkTo("flo");
		wait_walkto();
		
		if ( game:Get( "got_permit" ) == 1 and game:Get( "talked_to_barb_1" ) ~= 1 ) then
			wait_fade();
			actor:StartProc(talk_to_barb);
		else
			actor:Face(DIR.S);
			actor:SetMode(MODE.FOLLOWCLICKS);
		end
	end;
	on_arrive = function(flo, button)
		if ( game:Get( "got_permit" ) == 1 ) then
			if ( game:Get( "talked_to_barb_2" ) == 1 ) then
				if ( game:Get( "got_permit_signed" ) == 1 ) then
					flo:StartProc(flo_need_stamped);	
				else
					flo:StartProc(flo_need_50);			
				end
			elseif BAG_INV:CheckInventory("mugs") then
				convproc("FLO", "quip_bigcorp_music");
			else
				flo:StartProc(flo_need_mugs);	
			end
		else
			flo:StartProc(flo_need_permit);			
		end
	end;
	
	on_use_inv = function(item, flo, flo2)
		flo_inv_generic(flo, item);
		return RESPONSE.INV_HANDLED;
	end;
};

number_sign_spec = 
{
	name = "NUMBER_SIGN";
	
	command = function(actor)
		actor:SetDepthValue(500);
		actor:ModifySaySpec
		{
			font = "fonts/broadway.mvec",
			color = { a = 1, r = 0.9, g = 0.96, b = 0.98 },
			outline_size = 0,
			lineheight = 50,
			linepadding = -7,
		}
		
		actor:SetAlpha(1.0);
		
		actor:Say("text_number_sign");
		actor:StopWalking();
		actor:SetPolygon({x=516,y=190}, {x=620,y=190}, {x=507,y=229}, {x=609,y=226});
		actor:TextToImage(40, 10);
	end;
}

permits_sign_spec = 
{
	name = "PERMITS_SIGN";
	
	command = function(actor)
		actor:SetDepthValue(500);
		actor:ModifySaySpec
		{
			font = "fonts/helvetica_nevelt_std_blk.mvec",
			color = { a = 1, r = 0, g = 0., b = 0 },
			outline_size = 0,
			lineheight = 50,
			linepadding = -7,
		}
		
		actor:SetAlpha(1.0);
		
		actor:Say("text_permits_sign");
		actor:StopWalking();
		actor:SetPolygon({x=24,y=150}, {x=114,y=179}, {x=26,y=181}, {x=114,y=209});
		actor:TextToImage(10, 00);
	end;
}

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		sfx:SetMusic("audio/music/music_big_corp.ogg", true);
		scene:SetRoomScale(360, 490, 0.6, 0.8);	--topline, bottomline, topscale, bottomscale
		
		fade_scene_up();
		
		if IsCheatMode() then
			--game:Set("got_permit", 1);
			--BAG_INV:RemoveInventory("mugcollection");
			--BAG_INV:AddInventory(inv_desc_mugs);
		end
		
		game:Set( "max_mugs", 10 )
		
		-- REMOVE WHEN PERMITS OFFICE WORKS
--		game:Set( "got_permit", 1 );
--		BAG_INV:AddInventory(inv_desc_permit);
		spawn_nav_arrow(permit_office_door_spec);
		spawn_nav_arrow(maze_spec);
		
		if ( game:Get( "got_permit" ) == 1 and game:Get( "talked_to_barb_2" ) ~= 1 ) then
			scene:Spawn(barb_spec);
		end
	end;
};

scene_spec =
{
	atlas = 
	{
		"pieces",
	};
	
	bg_image = 
	{
		{ "background", DEPTH.DEPTH_BACKMOST  },
		
		{ "plant_left", DEPTH.DEPTH_FRONTMOST  },
		{ "plant_right", DEPTH.DEPTH_FRONTMOST  },
	};
	
	--lightmap = "lightmap";	-- use the ground as the lightmap
	
	ground = "background";
	
	actorlist = 
	{ 
		elevator_spec,
		elevator_button_spec,
		flo_spec, -- the main actor
		
		scene_setup,
		number_sign_spec,
		permits_sign_spec,
	};
};
